% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA.R
\name{gseafun}
\alias{gseafun}
\title{Gene Set Enrichment Analysis (GSEA) Function}
\usage{
gseafun(genelist, pathlist, nperm = 1000, weighted = 1)
}
\arguments{
\item{genelist}{A named vector of gene expression values.}

\item{pathlist}{A list of gene sets (pathways) to test for enrichment.}

\item{nperm}{Number of permutations for calculating p-values (default is 1000).}

\item{weighted}{Logical indicating whether to use weighted enrichment scores (default is TRUE).}
}
\value{
A data frame with enrichment scores (ES), p-values, and adjusted p-values.
}
\description{
This function performs gene set enrichment analysis using a gene list and a set of pathways.
}
\examples{
data(path_list, package = "iPRISM")
data(genelist_imm, package = "iPRISM")
\donttest{
res_gsea_imm <- gseafun(genelist = genelist_imm,
                        pathlist = path_list[1:2],
                        weighted = 1,
                        nperm = 1000)
print(res_gsea_imm)
}

}
