% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{add.selection}
\alias{add.selection}
\alias{add.selection,Cube-method}
\title{Adds selection criteria to a hypercube}
\usage{
add.selection(x, criteria)
}
\arguments{
\item{x}{Hypercube for which the selection criteria will be defined.}

\item{criteria}{A list of selection criteria.}
}
\value{
Returns a \code{Cube} object with the added selection criteria.
}
\description{
This function adds further selection criteria to a hypercube.
The cube itself will not be changed. The selection criteria only affect the data that
will be shown when printing the cube. Note that selection criteria will be applied before
aggregating the data.
}
\examples{

data("sales")
print(str(sales))
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube = add.selection(cube, criteria = list(state = c("CA", "FL")))
cube
cube = add.selection(cube, criteria = list(state = c("TX")))
cube

}
\seealso{
\code{\link[=Cube-class]{Cube}} \code{\link{remove.selection}} \code{\link{add.aggregation}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
