% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guesswavelength.R
\name{guess.wavelength}
\alias{guess.wavelength}
\title{guess wavelengths from character vector}
\usage{
guess.wavelength(X)
}
\arguments{
\item{X}{character with numbers hidden inside}
}
\value{
numeric
}
\description{
character vectors used for names (e.g. colnames for matrices or data.frames) 
are often treated by \code{\link[base]{make.names}} or similar functions that
produce suitable names (e.g. by prepending "X" to numbers.). Such names 
cannot be directly converted to numeric.
}
\details{
\code{guess.wavlength} tries to extract numbers from X which may be
surrounded by such "protecting" characters.
}
\examples{
tmp <- data.frame(flu [[,, 400 ~ 410]])
(wl <- colnames (tmp))
guess.wavelength (wl)
}
