% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.R
\name{Extract}
\alias{Extract}
\title{Extracting columns and generating required interaction effects from data\cr}
\usage{
Extract(X, varind, interaction.ind = NULL)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects. Note that the interaction
effects should not be included in \code{X} because this function
automatically generates the corresponding interaction effects if needed.}

\item{varind}{A numeric vector that specifies the indices of variables to be
extracted from \code{X}. Duplicated values are not allowed. See Example
for details.}

\item{interaction.ind}{A two-column numeric matrix. Each row represents a unique
interaction pair, with the columns indicating the index numbers of the variables
involved in each interaction. Note that \code{interaction.ind} must be generated
outside of this function using \code{t(utils::combn(p,2))}. See Example section for
details.}
}
\value{
A numeric matrix is returned.
}
\description{
This function simplifies the data preparation process by enabling users to
extract specific columns from their dataset \code{X}, and automatically
generating any necessary interaction effects based on \code{varind}.
}
\examples{
# Generate interaction.ind
interaction.ind <- t(combn(4,2))

# Generate data
set.seed(0)
X <- matrix(rnorm(20), ncol = 4)
y <- X[, 2] + rnorm(5)

# Extract X1 and X1X2 from X1, ..., X4
Extract(X, varind = c(1,5), interaction.ind)

# Extract X5 from X1, ..., X4
Extract(X, varind = 5, interaction.ind)

# Extract using duplicated values
try(Extract(X, varind = c(1,1), interaction.ind)) # this will not run

}
