% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/back-compatibility.R
\name{get_config_tid}
\alias{get_config_tid}
\title{Get the name of the output type id column based on the schema version}
\usage{
get_config_tid(config_version, config_tasks)
}
\arguments{
\item{config_version}{Character string of the schema version.}

\item{config_tasks}{a list version of the content's of a hub's \code{tasks.json}
config file, accessed through the \code{"config_tasks"} attribute of a \verb{<hub_connection>}
object or function \code{\link[=read_config]{read_config()}}.}
}
\value{
character string of the name of the output type id column
}
\description{
Version can be provided either directly through the \code{config_version} argument
or extracted from a \code{config_tasks} object.
}
\examples{
get_config_tid("v3.0.0")
get_config_tid("v2.0.0")
\dontshow{if (asNamespace("hubUtils")$not_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# this will produce a warning because support for schema version 1.0.0
# has been dropped.
get_config_tid("v1.0.0")
\dontshow{\}) # examplesIf}
}
