% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lit_css.R
\name{get_lit_css}
\alias{get_lit_css}
\title{Get literature Css}
\usage{
get_lit_css(
  chem.cas = NULL,
  chem.name = NULL,
  daily.dose = 1,
  which.quantile = 0.95,
  species = "Human",
  clearance.assay.conc = NULL,
  output.units = "mg/L",
  suppress.messages = FALSE
)
}
\arguments{
\item{chem.cas}{Either the cas number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{daily.dose}{Total daily dose infused in units of mg/kg BW/day.
Defaults to 1 mg/kg/day.}

\item{which.quantile}{Which quantile from the SimCYP Monte Carlo simulation
is requested. Can be a vector.}

\item{species}{Species desired (either "Rat" or default "Human").}

\item{clearance.assay.conc}{Concentration of chemical used in measureing
intrinsic clearance data, 1 or 10 uM.}

\item{output.units}{Returned units for function, defaults to mg/L but can
also be uM (specify units = "uM").}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
A numeric vector with the literature steady-state plasma 
concentration (1 mg/kg/day) for the requested quantiles
}
\description{
This function retrieves a steady-state plasma concentration as a result of
infusion dosing from the Wetmore et al. (2012) and (2013) publications and
other literature.
}
\examples{
get_lit_css(chem.cas="34256-82-1")

get_lit_css(chem.cas="34256-82-1",species="Rat",which.quantile=0.5)

get_lit_css(chem.cas="80-05-7", daily.dose = 1,which.quantile = 0.5, output.units = "uM")

}
\references{
\insertRef{wetmore2012integration}{httk}

\insertRef{wetmore2013relative}{httk}

\insertRef{wetmore2015incorporating}{httk}
}
\author{
John Wambaugh
}
\keyword{Literature}
\keyword{Monte-Carlo}
