#include "MMatrix.h"
#include <Rcpp.h>

// pour celui ci target est un vecteur R du bon type
// [[Rcpp::export]]
void extract_mvector_to_R(SEXP pM, std::string datatype, Rcpp::IntegerVector I, SEXP target) {
  if (datatype == "float") { 
    Rcpp::XPtr<houba::MMatrix<float>> instanc(pM);
    Rcpp::NumericVector tar(target);
    instanc->extract_vector(I, tar);
  } else if (datatype == "double") {
    Rcpp::XPtr<houba::MMatrix<double>> instanc(pM);
    Rcpp::NumericVector tar(target);
    instanc->extract_vector(I, tar);
  } else if (datatype == "integer") {
    Rcpp::XPtr<houba::MMatrix<int>> instanc(pM);
    Rcpp::IntegerVector tar(target);
    instanc->extract_vector(I, tar);
  } else if (datatype == "short") {
    Rcpp::XPtr<houba::MMatrix<int16_t>> instanc(pM);
    Rcpp::IntegerVector tar(target);
    instanc->extract_vector(I, tar);
  } else {
    throw std::runtime_error("Unsupported datatype for now !");
  }
}

// et pour celui ci target est un pointeur vers une mmatrix
// [[Rcpp::export]]
void extract_mvector_to_mvector(SEXP pM, std::string datatype, Rcpp::IntegerVector I, SEXP target) {
  if (datatype == "float") { 
    Rcpp::XPtr<houba::MMatrix<float>> instanc(pM);
    Rcpp::XPtr<houba::MMatrix<float>> tar(target);
    instanc->extract_vector(I, *tar);
  } else if (datatype == "double") {
    Rcpp::XPtr<houba::MMatrix<double>> instanc(pM);
    Rcpp::XPtr<houba::MMatrix<double>> tar(target);
    instanc->extract_vector(I, *tar);
  } else if (datatype == "integer") {
    Rcpp::XPtr<houba::MMatrix<int>> instanc(pM);
    Rcpp::XPtr<houba::MMatrix<int>> tar(target);
    instanc->extract_vector(I, *tar);
  } else if (datatype == "short") {
    Rcpp::XPtr<houba::MMatrix<int16_t>> instanc(pM);
    Rcpp::XPtr<houba::MMatrix<int16_t>> tar(target);
    instanc->extract_vector(I, *tar);
  } else {
    throw std::runtime_error("Unsupported datatype for now !");
  }
}


