% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_boxscore.R
\name{nba_boxscoreusagev2}
\alias{nba_boxscoreusagev2}
\title{\strong{Get NBA Stats API Boxscore Usage V2}}
\usage{
nba_boxscoreusagev2(
  game_id,
  start_period = 0,
  end_period = 14,
  start_range = 0,
  end_range = 0,
  range_type = 0,
  ...
)
}
\arguments{
\item{game_id}{Game ID}

\item{start_period}{start_period}

\item{end_period}{end_period}

\item{start_range}{start_range}

\item{end_range}{end_range}

\item{range_type}{range_type}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: sqlPlayersUsage, sqlTeamsUsage

\strong{sqlPlayersUsage}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   NICKNAME \tab character \cr
   START_POSITION \tab character \cr
   COMMENT \tab character \cr
   MIN \tab character \cr
   USG_PCT \tab character \cr
   PCT_FGM \tab character \cr
   PCT_FGA \tab character \cr
   PCT_FG3M \tab character \cr
   PCT_FG3A \tab character \cr
   PCT_FTM \tab character \cr
   PCT_FTA \tab character \cr
   PCT_OREB \tab character \cr
   PCT_DREB \tab character \cr
   PCT_REB \tab character \cr
   PCT_AST \tab character \cr
   PCT_TOV \tab character \cr
   PCT_STL \tab character \cr
   PCT_BLK \tab character \cr
   PCT_BLKA \tab character \cr
   PCT_PF \tab character \cr
   PCT_PFD \tab character \cr
   PCT_PTS \tab character \cr
}


\strong{sqlTeamsUsage}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   MIN \tab character \cr
   USG_PCT \tab character \cr
   PCT_FGM \tab character \cr
   PCT_FGA \tab character \cr
   PCT_FG3M \tab character \cr
   PCT_FG3A \tab character \cr
   PCT_FTM \tab character \cr
   PCT_FTA \tab character \cr
   PCT_OREB \tab character \cr
   PCT_DREB \tab character \cr
   PCT_REB \tab character \cr
   PCT_AST \tab character \cr
   PCT_TOV \tab character \cr
   PCT_STL \tab character \cr
   PCT_BLK \tab character \cr
   PCT_BLKA \tab character \cr
   PCT_PF \tab character \cr
   PCT_PFD \tab character \cr
   PCT_PTS \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Boxscore Usage V2}

\strong{Get NBA Stats API Boxscore Usage V2}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_boxscoreusagev2(game_id = "0022200021")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Boxscore Functions: 
\code{\link{nba_boxscoreadvancedv2}()},
\code{\link{nba_boxscoredefensive}()},
\code{\link{nba_boxscorefourfactorsv2}()},
\code{\link{nba_boxscorematchups}()},
\code{\link{nba_boxscoremiscv2}()},
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_boxscorescoringv2}()},
\code{\link{nba_boxscoresummaryv2}()},
\code{\link{nba_boxscoretraditionalv2}()},
\code{\link{nba_gamerotation}()},
\code{\link{nba_hustlestatsboxscore}()},
\code{\link{nba_live_boxscore}()}
}
\author{
Saiem Gilani
}
\concept{NBA Boxscore Functions}
