% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_s_tau.R
\name{hbl_s_tau}
\alias{hbl_s_tau}
\title{Superseded: suggest a value of s_tau}
\usage{
hbl_s_tau(precision_ratio = 0.5, sigma = 1, n = 100)
}
\arguments{
\item{precision_ratio}{Positive numeric vector of elements between 0 and 1
with target precision ratios.}

\item{sigma}{Positive numeric vector of residual standard deviations.}

\item{n}{Number of non-missing patients.}
}
\value{
Numeric of length equal to \code{length(precision_ratio)} and
\code{length(sigma)}, suggested values of s_tau for each element of
\code{precision_ratio} and \code{sigma}.
}
\description{
Superseded:
suggest a value of the \code{s_tau} hyperparameter
to roughly target a specified minimum amount of borrowing
in the hierarchical model with the uniform prior.
Only use if a diffuse prior on \code{tau} is not feasible.
}
\details{
The target minimum amount of borrowing
is expressed in the \code{precision_ratio} argument.
The precision ratio is a metric that quantifies the amount of
borrowing in the hierarchical model. See the "Methods" vignette
for details.
}
\examples{
hbl_s_tau(precision_ratio = 0.5, sigma = 1, n = 100)
}
\keyword{internal}
