% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_stats.R
\name{hexify_compare_resolutions}
\alias{hexify_compare_resolutions}
\title{Compare grid resolutions}
\usage{
hexify_compare_resolutions(aperture = 3, res_range = 0:15, print = FALSE)
}
\arguments{
\item{aperture}{Grid aperture (3, 4, or 7)}

\item{res_range}{Range of resolutions to compare (e.g., 1:10)}

\item{print}{If TRUE, prints a formatted table to console. If FALSE (default),
returns a data frame.}
}
\value{
If print=FALSE: data frame with columns resolution, n_cells,
cell_area_km2, cell_spacing_km, cls_km.
If print=TRUE: invisibly returns the data frame after printing.
}
\description{
Generates a table comparing different resolution levels for a given
grid configuration. Useful for choosing appropriate resolution.
}
\examples{
# Get data frame of resolutions 0-10 for aperture 3
comparison <- hexify_compare_resolutions(aperture = 3, res_range = 0:10)
print(comparison)

# Print formatted table directly
hexify_compare_resolutions(aperture = 3, res_range = 0:10, print = TRUE)

# Find resolution with cells ~1000 km^2
subset(comparison, cell_area_km2 > 900 & cell_area_km2 < 1100)
}
\seealso{
Other grid statistics: 
\code{\link{dg_closest_res_to_area}()},
\code{\link{dgearthstat}()},
\code{\link{hexify_area_to_eff_res}()},
\code{\link{hexify_eff_res_to_area}()},
\code{\link{hexify_eff_res_to_resolution}()},
\code{\link{hexify_resolution_to_eff_res}()}
}
\concept{grid statistics}
