% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifont.R
\name{unifont}
\alias{unifont}
\title{Load GNU Unifont font}
\usage{
unifont(
  upper = TRUE,
  jp = FALSE,
  csur = TRUE,
  sample = FALSE,
  ucp = NULL,
  cache = getOption("unifont.cache", NULL)
)
}
\arguments{
\item{upper}{Include glyphs above the Unicode Basic Multilingual plane.}

\item{jp}{Use Japanese version of Chinese characters.}

\item{csur}{Include (Under-)Conscript Unicode Registry glyphs.}

\item{sample}{Add circle to "Combining" characters.}

\item{ucp}{Character vector of Unicode Code Points: glyphs not in this vector won't be read in.
If \code{NULL} (default) read every glyph in the font.}

\item{cache}{If \code{TRUE} read a cached version of this font from
\code{tools::R_user_dir("hexfont", "cache")} if it exists and
if it does not exist than create a cached version of this font.
If \code{FALSE} don't read or write a cached version of this font (even if it exists).
If \code{NULL} read a cached version of this font if it exists but if it
does not exist then don't create it.
This argument is ignored if \code{ucp} is not \code{NULL}.}
}
\value{
A \code{\link[bittermelon:bm_font]{bittermelon::bm_font()}} object.
If \code{cache} is \code{TRUE} then as a side effect may create an \code{.rds} file
in \code{tools::R_user_dir("hexfont", "cache")}.
}
\description{
The function \code{unifont()} loads in several GNU Unifont hex files as a
single \code{\link[bittermelon:bm_font]{bittermelon::bm_font()}} object.
}
\examples{
# Much faster to load only the subset of GNU Unifont one needs
# Mandarin Chinese
if (require("bittermelon")) {
  s <- "\uff32\u5f88\u68d2\uff01"
  font <- unifont(ucp = str2ucp(s))
  bm <- as_bm_bitmap(s, font = font)
  print(bm, px = px_ascii)
}

# Emoji
if (require("bittermelon")) {
  s <- "\U0001f42d\U0001f432\U0001f435"
  font <- unifont(ucp = str2ucp(s))
  bm <- as_bm_bitmap(s, font = font)
  print(bm, px = px_ascii)
}

\donttest{# Will take more than 5s on CRAN machines
# Compiling the entire font from the hex files takes a long time
system.time(font <- unifont(cache = FALSE))
prettyNum(length(font), big.mark = ",") # number of glyphs
# It is usually much faster to use a cached version of the font
if (file.exists(hexfont:::unifont_cache_filename())) {
  system.time({font_from_cache <- unifont(cache = TRUE)})
}
}
}
