% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametise.R
\name{H2_Standard_parameters}
\alias{H2_Standard_parameters}
\title{Calculate Standard heritability using variance parameters}
\usage{
H2_Standard_parameters(vc_g, vc_e, n_r = 1)
}
\arguments{
\item{vc_g}{Numeric. Genotype variance component}

\item{vc_e}{Numeric. Residuals variance component}

\item{n_r}{A numeric vector of size n_g, the number of genotype replicates.}
}
\value{
Numeric value
}
\description{
Compute Standard heritability for genotype means using the variance components of genotype and residuals.
}
\details{
The equation for Standard heritability is as follows:

\deqn{H^2_{Standard} = \frac{\sigma^2_g}{\sigma^2_g + \frac{1}{n_g}\sum_{n_g}^{i=1} \sigma^2_p / n_{gi}}}
where:
\itemize{
\item \eqn{n_g} is the number of genotypes
\item \eqn{n_{gi}} is the number of replicate for a given genotype i
\item \eqn{\sigma_g} is the variance attributed to genotype differences
\item \eqn{\sigma_p} is the variance attributed to phenotypic differences
}
}
\examples{
H2_Standard_parameters(vc_g = 0.25, vc_e = 0.8)

}
\references{
Falconer, D. S., & Mackay, T. F. C. (1996). Introduction to quantitative genetics (4th ed.). Longman.
}
