% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meatCL.heckmanGE.R
\name{meatCL.heckmanGE}
\alias{meatCL.heckmanGE}
\title{meatCL.heckmanGE
Compute the Meat Matrix for a Heckman-Ge Model with Clustering}
\usage{
meatCL.heckmanGE(
  x,
  cluster = NULL,
  type = NULL,
  cadjust = TRUE,
  multi0 = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{heckmanGE} containing the results from a Heckman-Ge model fit.}

\item{cluster}{A vector or a data frame specifying the cluster variable(s). If \code{NULL}, the default clustering variable is used.}

\item{type}{The type of heteroscedasticity-consistent (HC) estimator to use. Options are "HC0", "HC1", "HC2", or "HC3". Defaults to "HC0".}

\item{cadjust}{A logical value indicating whether to adjust for the number of clusters. Defaults to \code{TRUE}.}

\item{multi0}{A logical value indicating whether to include a column of ones in the cluster variable matrix. Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A matrix representing the meat component of the robust covariance matrix estimator for the Heckman-Ge model.
}
\description{
This function calculates the meat matrix for a Heckman-Ge model, which is used in the context of clustered standard errors. The meat matrix represents the variability of the estimated parameters and is a crucial component for robust inference.
}
