% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-ts-arima.R
\name{ts_arima_simulator}
\alias{ts_arima_simulator}
\title{Simulate ARIMA Model}
\usage{
ts_arima_simulator(
  .n = 100,
  .num_sims = 25,
  .order_p = 0,
  .order_d = 0,
  .order_q = 0,
  .ma = c(),
  .ar = c(),
  .sim_color = "steelblue",
  .alpha = 0.05,
  .size = 1,
  ...
)
}
\arguments{
\item{.n}{The number of points to be simulated.}

\item{.num_sims}{The number of different simulations to be run.}

\item{.order_p}{The p value, the order of the AR term.}

\item{.order_d}{The d value, the number of differencing to make the series stationary}

\item{.order_q}{The q value, the order of the MA term.}

\item{.ma}{You can list the MA terms respectively if desired.}

\item{.ar}{You can list the AR terms respectively if desired.}

\item{.sim_color}{The color of the lines for the simulated series.}

\item{.alpha}{The alpha component of the \code{ggplot2} and \code{plotly} lines.}

\item{.size}{The size of the median line for the \code{ggplot2}}

\item{...}{Any other additional arguments for \link[stats:arima.sim]{stats::arima.sim}}
}
\value{
A list object.
}
\description{
Returns a list output of any \code{n} simulations of a user specified
ARIMA model. The function returns a list object with two sections:
\itemize{
\item data
\item plots
}

The data section of the output contains the following:
\itemize{
\item simulation_time_series object (ts format)
\item simulation_time_series_output (mts format)
\item simulations_tbl (simulation_time_series_object in a tibble)
\item simulations_median_value_tbl (contains the \code{\link[stats:median]{stats::median()}} value of the
simulated data)
}

The plots section of the output contains the following:
\itemize{
\item static_plot The \code{ggplot2} plot
\item plotly_plot The \code{plotly} plot
}
}
\details{
This function takes in a user specified arima model. The specification
is passed to \code{\link[stats:arima.sim]{stats::arima.sim()}}
}
\examples{
output <- ts_arima_simulator()
output$plots$static_plot

}
\seealso{
Other Simulator: 
\code{\link{ts_forecast_simulator}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Simulator}
