% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{walk_biomech_tbl_df}
\alias{walk_biomech_tbl_df}
\title{Running Injury Clinic Kinematic Dataset (Walking)}
\format{
A tibble with 2,088 observations and 26 variables:
\describe{
  \item{sub_id}{Numeric identifier for the subject.}
  \item{datestring}{Datetime object indicating the recording date.}
  \item{filename}{Character string specifying the source filename.}
  \item{speed_w}{Numeric value for treadmill walking speed.}
  \item{age}{Numeric value for subject's age.}
  \item{Height}{Numeric value for subject's height (in cm).}
  \item{Weight}{Numeric value for subject's weight (in kg).}
  \item{Gender}{Character string indicating subject's gender.}
  \item{DominantLeg}{Character string indicating the dominant leg.}
  \item{InjDefn}{Character string indicating the injury definition.}
  \item{InjJoint}{Character string indicating the injured joint.}
  \item{InjSide}{Character string indicating the injured side.}
  \item{SpecInjury}{Character string specifying the injury type.}
  \item{InjDuration}{Numeric value for injury duration (in weeks).}
  \item{InjJoint2}{Character string for additional injured joint information.}
  \item{InjSide2}{Character string for additional injured side information.}
  \item{SpecInjury2}{Character string for additional specific injury information.}
  \item{Activities}{Character string indicating physical activities.}
  \item{Level}{Character string indicating running level.}
  \item{YrsRunning}{Numeric value for years of running experience.}
  \item{RaceDistance}{Character string indicating typical race distance.}
  \item{RaceTimeHrs}{Character string for race completion time (hours).}
  \item{RaceTimeMins}{Character string for race completion time (minutes).}
  \item{RaceTimeSecs}{Character string for race completion time (seconds).}
  \item{YrPR}{Numeric value for year of personal record.}
  \item{NumRaces}{Numeric value indicating number of races completed.}
}
}
\source{
Data taken from figshare:
\url{https://plus.figshare.com/articles/dataset/Running_Injury_Clinic_Kinematic_Dataset/24255795/1?file=42637045}
}
\usage{
data(walk_biomech_tbl_df)
}
\description{
This dataset, walk_biomech_tbl_df, is a tibble containing biomechanics data of human
subjects (\eqn{N = 2,088}) walking on a treadmill. Data include 3D marker positions
over trials ranging from 25 to 60 seconds. In addition, demographic information and
calculated variables of interest (such as step width, stride rate, peak knee flexion angle)
are provided. The dataset also comes with sample processing code and data analysis tutorials.
}
\details{
The dataset name has been kept as 'walk_biomech_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is stored as a tibble (data frame). The original content has not been modified
in any way.
}
