% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoIVselectX.R
\name{coef.rlassoIVselectX}
\alias{coef.rlassoIVselectX}
\title{Coefficients from S3 objects \code{rlassoIVselectX}}
\usage{
\method{coef}{rlassoIVselectX}(object, complete = TRUE, selection.matrix = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{rlassoIVselectX}, usually a result of a call 
\code{rlassoIVselectX} or \code{rlassoIV} with options \code{select.X=TRUE} and
\code{select.Z=FALSE}.}

\item{complete}{general option of the function \code{coef}.}

\item{selection.matrix}{if TRUE, a selection matrix is returned that indicates the selected variables from each regression.
Default is set to FALSE. See section on details for more information.}

\item{...}{further arguments passed to functions coef.}
}
\description{
Method to extract coefficients and selection matrix from objects of class \code{rlassoIVselectX}.
}
\details{
Printing coefficients and selection matrix for S3 object \code{rlassoIVselectX}. The first column of the selection matrix reports the selection index for the lasso regression of \code{y} on \code{x} in the specified
\code{rlassoIVselectX} command. \code{"x"} indicates that a variable has been selected, i.e., the corresponding estimated coefficient is different from zero.
The second column contains the selection index for the lasso regression of \code{d} on \code{x} and the remaining columns
the index of selected variables \code{x} for the instruments \code{z}. The very last column collects all variables that have been selected in at least one of the lasso regressions.
}
\examples{
\dontrun{
library(hdm)
data(AJR); y = AJR$GDP; d = AJR$Exprop; z = AJR$logMort
x = model.matrix(~ -1 + (Latitude + Latitude2 + Africa + 
                           Asia + Namer + Samer)^2, data=AJR)
AJR.Xselect = rlassoIV(GDP ~ Exprop +  (Latitude + Latitude2 + Africa + Asia + Namer + Samer)^2 |
                         logMort +  (Latitude + Latitude2 + Africa + Asia + Namer + Samer)^2,
                       data=AJR, select.X=TRUE, select.Z=FALSE)
coef(AJR.Xselect) # Default behavior
coef(AJR.Xselect, selection.matrix = TRUE) # print selection matrix
}
}
