/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Omodule.h" 

#include "H5private.h"   
#include "H5Eprivate.h"  
#include "H5FLprivate.h" 
#include "H5Opkg.h"      

static herr_t H5O__unknown_free(void *_mesg);

const H5O_msg_class_t H5O_MSG_UNKNOWN[1] = {{
    H5O_UNKNOWN_ID,    
    "unknown",         
    0,                 
    0,                 
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    H5O__unknown_free, 
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL,              
    NULL               
}};

H5FL_DEFINE(H5O_unknown_t);

static herr_t
H5O__unknown_free(void *mesg)
{
    FUNC_ENTER_PACKAGE_NOERR

    assert(mesg);

    mesg = H5FL_FREE(H5O_unknown_t, mesg);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 
