% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{guess_delim}
\alias{guess_delim}
\title{Guesses the delimiter of a text file}
\usage{
guess_delim(path)
}
\arguments{
\item{path}{The path to a text file containing a rectangular data set.}
}
\value{
It returns a character string of length 1: the delimiter.
}
\description{
This function uses \code{\link[data.table]{fread}} to guess the delimiter of a text file.
}
\examples{

# Example with the iris data set
iris_path = tempfile()
fwrite(iris, iris_path)

guess_delim(iris_path)

}
\seealso{
See \code{\link[hdd]{peek}} to have a convenient look at the first lines of a text file. See \code{\link[hdd]{guess_delim}} to guess the delimiter of a text data set. See \code{\link[hdd]{guess_col_types}} to guess the column types of a text data set.

See \code{\link[hdd]{hdd}}, \code{\link[hdd]{sub-.hdd}} and \code{\link[hdd]{cash-.hdd}} for the extraction and manipulation of out of memory data. For importation of HDD data sets from text files: see \code{\link[hdd]{txt2hdd}}.
}
\author{
Laurent Berge
}
