% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize_descriptives_gt}
\alias{summarize_descriptives_gt}
\title{Generate Detailed Descriptive Statistics with Custom P-Value Tests}
\usage{
summarize_descriptives_gt(
  data,
  patient_id_col = "patient_id",
  var_list = NULL,
  group_var_main = "cohort",
  group_var_by = "care_setting",
  test = NULL,
  timeline = "Pre"
)
}
\arguments{
\item{data}{A dataframe with variables to summarize from the output of
the summarize_descriptives function. Kindly filter the data for timeline.}

\item{patient_id_col}{A character specifying the name of patient identifier
column.}

\item{var_list}{Optional quoted variable list (e.g. care_setting).}

\item{group_var_main}{A character specifying the name of the main
grouping column.}

\item{group_var_by}{A character specifying the name of the secondary
grouping column.}

\item{test}{Optional named list of statistical tests
(e.g. age ~ "wilcox.test").}

\item{timeline}{A character specifying the timeline window (default "Pre").}
}
\value{
A gtsummary table object
}
\description{
Generate Detailed Descriptive Statistics with Custom P-Value Tests
}
\examples{
 \donttest{
if (requireNamespace("gtsummary", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE) &&
    requireNamespace("purrr", quietly = TRUE) &&
    requireNamespace("checkmate", quietly = TRUE) &&
    requireNamespace("glue", quietly = TRUE)) {
  hcru_sample_data <- data.frame(
    patient_id = rep(1:10, each = 2),
    cohort = rep(c("A", "B"), 10),
    care_setting = rep(c("IP", "OP"), 10),
    admission_date = Sys.Date() - sample(1:100, 20, TRUE),
    discharge_date = Sys.Date() - sample(1:90, 20, TRUE),
    index_date = Sys.Date() - 50,
    visit_date = Sys.Date() - sample(1:100, 20, TRUE),
    encounter_id = 1:20,
    cost_usd = runif(20, 100, 1000)
  )
  df <- preproc_hcru_fun(data = hcru_sample_data)
  summary_df <- summarize_descriptives(data = df)
  # Only keep required columns for demonstration
  summary_df$LOS <- ifelse(summary_df$care_setting == "IP",
sample(1:10, nrow(summary_df), TRUE), NA)
  summary_df$Readmission <- ifelse(summary_df$care_setting == "IP",
sample(0:1, nrow(summary_df), TRUE), NA)
  summary_df$time_window <- "Pre"
  # Run the function (should execute within 5 seconds)
  summarize_descriptives_gt(
    data = summary_df,
    patient_id_col = "patient_id",
    var_list = c("Visits", "Cost", "LOS", "Readmission"),
    group_var_main = "cohort",
    group_var_by = "care_setting",
    timeline = "Pre"
  )
}
}
}
