% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbsae.R
\name{bench}
\alias{bench}
\title{Benchmark small area estimates.}
\usage{
bench(x, R, rhs, mseMethod = "no", Omega, Lambda)
}
\arguments{
\item{x}{sae object to be benchmarked. As an alternative, a list can be supplied with at least components \code{Narea} with
area population sizes and \code{est} with small area estimates. In the latter case argument \code{Omega} cannot be left unspecified.}

\item{R}{restriction matrix, M x r matrix where r is the number of restrictions and M the number of areas; default is a single constraint on the population total.
Note that \code{R} acts on the vector of area totals, not the vector of means.}

\item{rhs}{r-vector of benchmark totals corresponding to the restrictions represented by (the columns of) \code{R}.}

\item{mseMethod}{if \code{"no"}, MSEs are not updated, if \code{"exact"}, constraints are treated as independent information
(exact identities by default), and if \code{"model"}, the squared differences between original and benchmarked estimates are added to the MSEs.}

\item{Omega}{M x M matrix \eqn{\Omega} in objective function, see details. By default this is the covariance
matrix of the small area estimates.}

\item{Lambda}{r x r matrix \eqn{\Lambda} in objective function, see details. By specifying \code{Lambda}
it is possible to impose 'soft' constraints, i.e. constraints that need to hold only approximately.}
}
\value{
An object of class \code{sae} with adjusted estimates.
}
\description{
Benchmark small area estimates to conform to given totals at aggregate levels.
}
\details{
This function adjusts the small area estimates \code{EST(x)}, denoted by \eqn{x_0}{x0}, to
\deqn{x_1 = x_0 + \Omega R_N (R_N' \Omega R_N + \Lambda)^{-1} (t - R_N' x_0)\,,}{x1 = x0 + \Omega S (S' \Omega S + \Lambda)^{-1} (t - S' x0)}
where
\itemize{
\item \eqn{\Omega}
      is a symmetric M x M matrix. By default, \eqn{\Omega} is taken to be the covariance matrix \eqn{V_0}{V0}
      of the input sae-object \code{x}.
\item \eqn{R_N = {\rm diag}(N_1,\dots, N_M)\,R}{S = diag(N1,N2,\dots)R}
      where \eqn{R} is the matrix passed to \code{bench} and \eqn{N_i}{Ni} denotes the population size
      of the \eqn{i}th area, is a M x r matrix describing the aggregate level relative to the area level.
      Note that the matrix \eqn{R} acts on the vector of area totals whereas \eqn{R_N}{S} acts on the area means to
      produce the aggregate totals.
      The default for \eqn{R} is a column vector of 1s representing an additivity constraint to the overall population total.
\item \eqn{t} is an r-vector of aggregate-level totals, specified as \code{rhs}, that the small area estimates should add up to.
\item \eqn{\Lambda} is a symmetric r x r matrix controlling the penalty associated with deviations from the constraints
      \eqn{R_N' x_1 = t}{S' x1 = t}.
      The default is \eqn{\Lambda=0}, implying that the constraints must hold exactly.
}

The adjusted or benchmarked small area estimates minimize the expectation of the loss function
\deqn{L(x_1, \theta) = (x_1 - \theta)' \Omega^{-1} (x_1 - \theta) + 
       (R_N' x_1 - t)' \Lambda^{-1} (R_N' x_1 - t)}{L(x1, \theta) =
       (x1 - \theta)' \Omega^{-1} (x1 - \theta) + (S' x1 - t)' \Lambda^{-1} (S' x1 - t)}
with respect to the posterior for the unknown small area means \eqn{\theta}.

Optionally, \code{MSE(x)} is updated as well. If \code{mseMethod="exact"} the covariance matrix is adjusted from
\eqn{V_0}{V0} to
\deqn{V_1 = V_0 - V_0 R_N (R_N' \Omega R_N + \Lambda)^{-1} R_N' V_0\,,}{V1 = V0 - V0 S (S' \Omega S + \Lambda)^{-1} S' V0}
and if \code{mseMethod} is \code{"model"} the adjusted covariance matrix is
\deqn{V_1 = V_0 + (x_1 - x_0) (x_1 - x_0)'\,.}{V1 = V0 + (x1 - x0) (x1 - x0)'}
The latter method treats the benchmark adjustments as incurring a bias
relative to the best predictor under the model.
}
\examples{
d <- generateFakeData()

# compute small area estimates
sae <- fSAE(y0 ~ x + area2, data=d$sam, area="area", popdata=d$Xpop)

# calibrate to overall population total
sae.c <- bench(sae, rhs=sum(d$mY0*sae$Narea))
plot(sae, sae.c)
}
\references{
G.S. Datta, M. Ghosh, R. Steorts and J. Maples (2011). Bayesian benchmarking with applications to small area estimation. TEST 20(3), 574-588.

  Y. You, J.N.K. Rao and P. Dick (2004). Benchmarking Hierarchical Bayes Small Area Estimators
    in the Canadian Census Undercoverage Estimation. Statistics in Transition 6(5), 631-640.
}
\seealso{
\code{\link{sae-class}}
}
