% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflows.R
\name{analyze_allele}
\alias{analyze_allele}
\title{Analyze allele profile}
\usage{
analyze_allele(
  bulk,
  t = 1e-05,
  theta_min = 0.08,
  gamma = 20,
  nu = 0.5,
  r = 0.015,
  hmm = "S5",
  fit_theta = FALSE,
  fit_gamma = FALSE,
  theta_start = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{bulk}{dataframe Bulk allele profile}

\item{t}{numeric Transition probability}

\item{theta_min}{numeric Minimum allele fraction}

\item{gamma}{numeric Overdispersion parameter}

\item{nu}{numeric Phase switch rate}

\item{r}{numeric Alternative allele count bias}

\item{hmm}{character HMM model to use (S3 or S5)}

\item{fit_theta}{logical Whether to fit theta_min}

\item{fit_gamma}{logical Whether to fit gamma}

\item{theta_start}{numeric Starting value for theta_min}

\item{verbose}{logical Whether to print progress}
}
\value{
dataframe Bulk allele profile with CNV states
}
\description{
Analyze allele profile
}
\examples{
bulk_example = analyze_allele(bulk_example, hmm = 'S5')
}
