% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfdfva.R
\name{dfdfva}
\alias{dfdfva}
\title{Domestic Final Demand Foreign Value Added}
\usage{
dfdfva(x, aggregate = FALSE)
}
\arguments{
\item{x}{A Leontief decomposed Inter-Country Input Output table as created by decompr, which should be post multiplied with final demand (using the parameter: post="final_demand")}

\item{aggregate}{should dfddva be aggregated along source industries to a national sum?}
}
\description{
Domestic Final Demand Foreign Value Added
}
\examples{
# load the decompr package
library(decompr)

# load the example data
data(leather)
attach(leather)

# create a leontief decomposed data set
l <- decomp(x = inter,
            y = final,
            k = countries,
            i = industries,
            o = out,
            method = "leontief",
            post = "final_demand")

 # apply dfdfva
 dfdfva( l )
}
