% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_pct_extra.R
\name{fmt_pct_extra}
\alias{fmt_pct_extra}
\title{Convert to percent and show less than 1\% as <1\% in grey}
\usage{
fmt_pct_extra(gt_object, columns, ..., scale = 1)
}
\arguments{
\item{gt_object}{An existing gt table}

\item{columns}{The columns to affect}

\item{...}{Additional argument passed to \code{scales::label_percent()}}

\item{scale}{A number to multiply values by, defaults to 1}
}
\value{
a gt table
}
\description{
Convert to percent and show less than 1\% as <1\% in grey
}
\examples{
library(gt)
pct_tab <- dplyr::tibble(x = c(.001, .05, .008, .1, .2, .5, .9)) \%>\%
  gt::gt() \%>\%
  fmt_pct_extra(x, scale = 100, accuracy = .1)
}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
