% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_t_freezing_first_derivatives_poly}
\alias{gsw_t_freezing_first_derivatives_poly}
\title{Derivatives of Freezing Water Properties (Polynomial version)}
\usage{
gsw_t_freezing_first_derivatives_poly(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
a list containing \code{tfreezing_SA} [ K/(g/kg) ], the derivative of freezing
temperature with Absolute Salinity and
\code{tfreezing_p} [ K/dbar ], the derivative with respect to pressure.
}
\description{
Derivatives of Freezing Water Properties (Polynomial version)
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(               34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(                     10,      50,     125,     250,     600,    1000)
saturation_fraction <- c(    1,     0.8,     0.6,     0.5,     0.4,       0)
derivs <- gsw_t_freezing_first_derivatives_poly(SA, p, saturation_fraction)
stopifnot(all.equal(derivs$tfreezing_SA,
    c(-0.056810211094078, -0.056855567524973, -0.056901968693345,
      -0.056903498206432, -0.056975157476629, -0.057083526206200)))
stopifnot(all.equal(derivs$tfreezing_p/1e-7,
    c(-0.748987354878138, -0.750288853857513, -0.752676389629787,
      -0.756549680608529, -0.767482625710990, -0.779985619685683)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_t_freezing_first_derivatives.html}
}
