% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solve.beta.given.power.R
\name{Solve.beta.given.power}
\alias{Solve.beta.given.power}
\title{Function to solve for the treatment effect parameter to achieve target power by Monte Carlo simulation.}
\usage{
Solve.beta.given.power(
  nsim = 1000,
  params,
  estimator,
  tol = 0.001,
  seed = NULL
)
}
\arguments{
\item{nsim}{Integer giving the number of Monte Carlo replicates used for each iteration. Default is \code{1000}.}

\item{params}{A data frame where each rows defines a simulation/design scenario. Must include a column \code{Type} with
values \code{"TypeI"} or \code{"Power"}. For \code{"Power"} scenarios, the function expects the following columns:
\code{placebo.lambda_0}, \code{grp.size}, \code{recruitment},
and \code{random.censor.rate}. Additional columns are carried through to the output.}

\item{estimator}{Character string specifying which calibration method to use:
\code{"LR"} for the generalized log-rank statistic or \code{"GT"} for the
generalized-t statistic.}

\item{tol}{Positive numeric value giving the convergence tolerance for the
fixed-point iteration in \code{beta.trt}. The algorithm stops when
\code{abs(beta.trt.old - beta.trt.new) < tol}. Default is \code{0.001}.}

\item{seed}{Seed for reproducibility.}
}
\value{
A data.frame with the same rows as \code{params} and an additional
column \code{beta.trt} containing the solved treatment effect coefficient.
For \code{Type == "TypeI"}, \code{beta.trt} is set to \code{0}. For
\code{Type == "Power"}, \code{beta.trt} is the converged solution from the
Monte Carlo calibration procedure.
}
\description{
For each design scenario in \code{params}, this function solves for the treatment effect coefficient \code{beta.trt} that achieves the
desired power using an iterative Monte Carlo calibration procedure. For scenarios labeled \code{TypeI}, the function sets \code{beta.trt = 0}.
For scenarios labeled \code{Power}, it repeatedly simulates two-sample composites data, estimates calibration quantities (a power constant and
variance) using either the generalized log-rank (\code{"LR"}) or generalized-t (\code{"GT"}) approach, updtaes \code{beta.trt} using
\code{find.beta.trt()}, and iterates until convergence within \code{tol}.
}
