
# gsMeanFreq

<!-- badges: start -->
<!-- badges: end -->

Group sequential methods for composite endpoints based on mean frequency
functions with recurrent and terminal events.

## Description

The package implements simulation, estimation, and power calibration
procedures for group sequential designs with composite endpoints,
including recurrent events and terminal events. Both one-sample and
two-sample settings are supported, with calendar-time monitoring.

## Installation

``` r
install.packages("gsMeanFreq")
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(gsMeanFreq)
# Simulate one-sample composite endpoint data
df <- Onesample.generate.sequential(
  size = 200,
  recruitment = 3,
  calendar = 5,
  random.censor.rate = 0.05,
  seed = 123
)
OneSample.Estimator.sequential(data= df, t = c(1.5, 2.9, 4.6))
```

