% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\name{GSDTuneJob}
\alias{GSDTuneJob}
\title{GSDTuneJob}
\value{
An R6 class generator. Use \verb{$new()} to create a \code{GSDTuneJob} object.
}
\description{
GSDTuneJob

GSDTuneJob
}
\details{
R6 class representing a dependency-aware tuning job for group sequential
designs created by \code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}} or \code{\link[gsDesign:nSurv]{gsDesign::gsSurv()}}.
}
\examples{
job <- GSDTuneJob$new(target = "gsDesign", args = list(k = 3, alpha = 0.025))
job$spec$target
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{target}}{Target design function name (\code{"gsDesign"} or \code{"gsSurv"}).}

\item{\code{base_args}}{Named list of fixed arguments passed to the target function.}

\item{\code{tune_specs}}{Named list of tuning specifications for explored arguments.}

\item{\code{param_space}}{Internal parameter space used for configuration generation.}

\item{\code{spec}}{Audit record including base/tuned args and \code{sessionInfo()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSDTuneJob-new}{\code{GSDTuneJob$new()}}
\item \href{#method-GSDTuneJob-run}{\code{GSDTuneJob$run()}}
\item \href{#method-GSDTuneJob-results}{\code{GSDTuneJob$results()}}
\item \href{#method-GSDTuneJob-summarize}{\code{GSDTuneJob$summarize()}}
\item \href{#method-GSDTuneJob-design}{\code{GSDTuneJob$design()}}
\item \href{#method-GSDTuneJob-call_args}{\code{GSDTuneJob$call_args()}}
\item \href{#method-GSDTuneJob-best}{\code{GSDTuneJob$best()}}
\item \href{#method-GSDTuneJob-pareto}{\code{GSDTuneJob$pareto()}}
\item \href{#method-GSDTuneJob-plot}{\code{GSDTuneJob$plot()}}
\item \href{#method-GSDTuneJob-report}{\code{GSDTuneJob$report()}}
\item \href{#method-GSDTuneJob-clone}{\code{GSDTuneJob$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-new}{}}}
\subsection{Method \code{new()}}{
Create a new tune job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$new(target = c("gsDesign", "gsSurv", "gsSurvCalendar"), args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{Target function name (\code{"gsDesign"}, \code{"gsSurv"}, or \code{"gsSurvCalendar"}).}

\item{\code{args}}{Named list of evaluated arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-run"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-run}{}}}
\subsection{Method \code{run()}}{
Evaluate configurations under a search strategy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$run(
  strategy = c("grid", "random"),
  n = NULL,
  parallel = TRUE,
  seed = NULL,
  cache_dir = NULL,
  metrics_fun = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strategy}}{Search strategy (\code{"grid"} or \code{"random"}).}

\item{\code{n}}{Number of configurations for random search.}

\item{\code{parallel}}{Whether to evaluate configurations in parallel.}

\item{\code{seed}}{Optional seed for reproducibility.}

\item{\code{cache_dir}}{Optional directory to cache design objects as \code{RDS}.}

\item{\code{metrics_fun}}{Optional metric hook.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-results"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-results}{}}}
\subsection{Method \code{results()}}{
Return the results data.frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$results()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-summarize"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-summarize}{}}}
\subsection{Method \code{summarize()}}{
Summarize the run (counts + numeric metric summaries).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$summarize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-design"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-design}{}}}
\subsection{Method \code{design()}}{
Retrieve a design object for configuration \code{i}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$design(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Row index of the configuration.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-call_args"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-call_args}{}}}
\subsection{Method \code{call_args()}}{
Return the underlying argument list for configuration \code{i}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$call_args(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Row index of the configuration.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-best"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-best}{}}}
\subsection{Method \code{best()}}{
Rank configurations by a metric (with optional constraints).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$best(metric, direction = c("min", "max"), constraints = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{Metric column name.}

\item{\code{direction}}{Ranking direction (\code{"min"} or \code{"max"}).}

\item{\code{constraints}}{Optional constraints (function or expression).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-pareto"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-pareto}{}}}
\subsection{Method \code{pareto()}}{
Compute a Pareto (non-dominated) set for multiple metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$pareto(metrics, directions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metrics}}{Metric column names.}

\item{\code{directions}}{Directions for each metric (\code{"min"}/\code{"max"}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-plot"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-plot}{}}}
\subsection{Method \code{plot()}}{
Create a quick exploration plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$plot(metric, x, color = NULL, facet = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{Y-axis metric column name.}

\item{\code{x}}{X-axis column name.}

\item{\code{color}}{Optional color column name.}

\item{\code{facet}}{Optional faceting column name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-report"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-report}{}}}
\subsection{Method \code{report()}}{
Render an HTML report.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$report(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Output HTML file path.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSDTuneJob-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSDTuneJob-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSDTuneJob$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
