% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_row.R
\name{grob_row}
\alias{grob_row}
\title{Grob Row}
\usage{
grob_row(
  ...,
  p = 1,
  height = NA_real_,
  border = FALSE,
  border_aes_list = ga_list(),
  title = "",
  title_aes_list = ga_list(),
  title_p = 0.15,
  title_height = NA_real_,
  caption = "",
  caption_aes_list = ga_list(),
  caption_p = 0.15,
  caption_height = NA_real_,
  padding_p = 0.05,
  padding = NA_real_
)
}
\arguments{
\item{...}{A series of \code{\link{grob_col}}'s.}

\item{p}{The numeric proportion of the given height which should be given
to sub-grobs outputted in the grob-row. Defaults to 1.

Overridden if a \code{height} is supplied.}

\item{height}{The numeric height of the grob-row in millimeters.

Overrides the \code{p} parameter.}

\item{border}{A TRUE/FALSE argument corresponding to whether or not a
border around the outputted grob-row is desired.

Defaults to FALSE.}

\item{border_aes_list}{The list outputted by \code{\link{ga_list}}, which
controls aesthetics of the borders.

Ignored if \code{border} is set to FALSE.}

\item{title}{A character string which will be displayed as the title of the grob-row.}

\item{title_aes_list}{The list outputted by \code{\link{ga_list}}, which
controls aesthetics of the title of the grob-row.}

\item{title_p}{The numeric proportion of height within the grob-row which
will be used by the title grob.}

\item{title_height}{The numeric height in mm within the grob_column which will
be used by the title grob. Will override \code{title_p} if provided.}

\item{caption}{A character string which will be displayed as the caption of the grob-row.}

\item{caption_aes_list}{The list outputted by \code{\link{ga_list}}, which
controls aesthetics of the caption of the grob-row.}

\item{caption_p}{The numeric proportion of height within the grob-row which will be used by the caption grob.}

\item{caption_height}{The numeric height in mm within the grob_column which will
be used by the caption grob. Will override \code{caption_p} if provided.}

\item{padding_p}{The proportion of the minimum of the height and width which
will be used for the padding around the edge of the grob-row.

Overridden by any numeric value provided in the \code{padding} parameter.}

\item{padding}{The numeric amount of padding around the edge of the grob-row
in millimeters.

Overrides the \code{padding_p} parameter.}
}
\value{
An R6 class object which contains all the information needed to
carry on to its grob-columns and create the grob-row.
}
\description{
The grob-row function which helps gives the grob from the
\code{\link{grob_layout}} function its shape. Encompasses \code{\link{grob_col}}
within the overall grob-layout.
}
\examples{

grob_row(
  grob_col(1, border = TRUE),
  grob_col(2, border = TRUE)
  ) \%>\%
  view_grob(100, 100)

}
