% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmforest-varimp-plot.R
\name{plot.varimp}
\alias{plot.varimp}
\title{Plot Variable Importance}
\usage{
\method{plot}{varimp}(x, top_n = NULL, use_ggplot = TRUE, ...)
}
\arguments{
\item{x}{A \code{varimp} object from \code{varimp()}.}

\item{top_n}{Number of top variables to display (NULL for all).}

\item{use_ggplot}{Logical indicating whether to use ggplot2 (if available).}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
Invisibly returns the input object.
}
\description{
Creates a bar plot of variable importance scores with options for both
ggplot2 and base R graphics.
}
\examples{
\donttest{
 library(grmtree)
 library(hlt)
 data("asti", package = "hlt")
 asti$resp <- data.matrix(asti[, 1:4])

 # Fit forest with default parameters
 forest <- grmforest(resp ~ gender + group, data = asti)
 imp <- varimp(forest)
 plot(imp)
 plot(imp, top_n = 1) ## select top 1 importance variable
 plot(imp, use_ggplot = FALSE) # Use base R graphics
}

}
\seealso{
\code{\link{varimp}} calculates the variable importance for GRM
Forest, \code{\link{grmforest}} for GRM Forests,
\code{\link{grmforest.control}} creates a control object for \code{grmforest},
\code{\link{plot.grmtree}} creates plot for the \code{grmtree} object
}
