% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_gpv.R
\name{all_opt_gpv}
\alias{all_opt_gpv}
\title{Optimize All Generalized Path Values}
\usage{
all_opt_gpv(sociomatrix, p = Inf, node_costs = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{p}{a nonnegative real number that sets the 'p-norm' parameter for 
generalized path value calculation.}

\item{node_costs}{a list of costs, in order, of all nodes represented in the 
sociomatrix, all are assumed 0 if unspecified}
}
\value{
All optimal paths from source to target nodes in \code{sociomatrix}. To
    minimize memory usage, paths are returned as a list of trees in Dijkstra's 
    format. Specific paths can be unpacked with \code{unpack} as described in the
    example below.
}
\description{
Identify the path of optimal generalized path value from every source 
to every target in \code{sociomatrix}.
}
\seealso{
\code{\link{gpv}} to calculate the value of a user-specified path, 
    \code{\link{opt_gpv}} to identify the optimal path from a single source 
    node to a single target node
}
