% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_harmony.R
\name{is_harmony}
\alias{is_harmony}
\title{Check if two temporal granularities are harmonies}
\usage{
is_harmony(
  .data,
  gran1,
  gran2,
  hierarchy_tbl = NULL,
  facet_h = NULL,
  x_h = NULL
)
}
\arguments{
\item{.data}{A tsibble object.}

\item{gran1}{One of the temporal granularities to check for harmonies.}

\item{gran2}{The second temporal granularity in the pair.}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and their relationships.}

\item{facet_h}{highest level of facet variable that can be considered in harmony pair.}

\item{x_h}{highest level of x-axis variable that can be considered in harmony pair.}
}
\value{
TRUE if two granularties are harmonies.
}
\description{
Interaction of pair of granularities, categorised as harmony and clash
}
\examples{
library(tsibbledata)
vic_elec \%>\% is_harmony("hour_day", "day_week")
}
