% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_penalty.R
\name{compute_penalty}
\alias{compute_penalty}
\title{Penalty Function Computation}
\usage{
compute_penalty(omega, penalty, lambda, gamma = NA)
}
\arguments{
\item{omega}{A numeric value or vector at which the penalty is evaluated.}

\item{penalty}{A character string or vector specifying one or more penalty
types. Available options include:
\enumerate{
\item "lasso": Least absolute shrinkage and selection operator
\insertCite{tibshirani1996regression,friedman2008sparse}{grasps}.
\item "atan": Arctangent type penalty
\insertCite{wang2016variable}{grasps}.
\item "exp": Exponential type penalty
\insertCite{wang2018variable}{grasps}.
\item "lq": Lq penalty
\insertCite{frank1993statistical,fu1998penalized,fan2001variable}{grasps}.
\item "lsp": Log-sum penalty
\insertCite{candes2008enhancing}{grasps}.
\item "mcp": Minimax concave penalty
\insertCite{zhang2010nearly}{grasps}.
\item "scad": Smoothly clipped absolute deviation
\insertCite{fan2001variable,fan2009network}{grasps}.
}
If \code{penalty} has length 1, it is recycled to the common length
determined by \code{penalty}, \code{lambda}, and \code{gamma}.}

\item{lambda}{A non-negative numeric value or vector specifying
the regularization parameter.
If \code{lambda} has length 1, it is recycled to the common length
determined by \code{penalty}, \code{lambda}, and \code{gamma}.}

\item{gamma}{A numeric value or vector specifying the additional parameter
for the penalty function.
If \code{lambda} has length 1, it is recycled to the common length
determined by \code{penalty}, \code{lambda}, and \code{gamma}.
The penalty-specific defaults are:
\enumerate{
\item "atan": 0.005
\item "exp": 0.01
\item "lq": 0.5
\item "lsp": 0.1
\item "mcp": 3
\item "scad": 3.7
}
For \code{"lasso"}, \code{gamma} is ignored.}
}
\value{
A data frame with S3 class \code{"penalty"} containing:
\describe{
\item{omega}{The input \code{omega} values.}
\item{penalty}{The penalty type for each row.}
\item{lambda}{The regularization parameter used.}
\item{gamma}{The additional penalty parameter used.}
\item{value}{The computed penalty value.}
}
The number of rows equals
\code{max(length(penalty), length(lambda), length(gamma))}.
Any of \code{penalty}, \code{lambda}, or \code{gamma} with length 1
is recycled to this common length.
}
\description{
Compute one or more penalty values for a given \code{omega}, allowing
vectorized specifications of \code{penalty}, \code{lambda}, and \code{gamma}.
}
\examples{
library(grasps)
library(ggplot2)

pen_df <- compute_penalty(
  omega = seq(-4, 4, by = 0.01),
  penalty = c("atan", "exp", "lasso", "lq", "lsp", "mcp", "scad"),
  lambda = 1)

plot(pen_df, xlim = c(-1, 1), ylim = c(0, 1), zoom.size = 1) +
  guides(color = guide_legend(nrow = 2, byrow = TRUE))
}
\references{
\insertAllCited{}
}
