% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_geo_dist.R
\name{mat_geo_dist}
\alias{mat_geo_dist}
\title{Compute Euclidean geographic distances between points}
\usage{
mat_geo_dist(
  data,
  ID = NULL,
  x = NULL,
  y = NULL,
  crds_type = "proj",
  gc_formula = "vicenty"
)
}
\arguments{
\item{data}{An object of class :\itemize{
\item \code{data.frame} with 3 columns: 2 columns with the point spatial
coordinates and another column with point IDs
\item \code{SpatialPointsDataFrame} }}

\item{ID}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the point IDs}

\item{x}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the point longitude}

\item{y}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the point latitude}

\item{crds_type}{A character string indicating the type of coordinate
reference system:\itemize{
\item{'proj' (default): a projected coordinate reference system}
\item{'polar': a polar coordinate reference system, such as WGS84}
}}

\item{gc_formula}{A character string indicating the formula used to compute
the Great Circle distance:\itemize{
\item{'vicenty'(default): Vincenty inverse formula for ellipsoids}
\item{'slc': Spherical Law of Cosines}
\item{'hvs': Harversine formula}
}}
}
\value{
A pairwise matrix of geographic distances between points in meters
}
\description{
The function computes Euclidean geographic distance between
points given their spatial coordinates either in a metric projected
Coordinate Reference System or in a polar coordinates system.
}
\details{
When a projected coordinate reference system is used, it calculates
classical Euclidean geographic distance between two points using
Pythagora's theorem. When a polar coordinate reference system is used, it
calculates the Great circle distance between points using different methods.
Unless \code{method = "polar"}, when \code{data} is a \code{data.frame},
it assumes projected coordinates by default.
}
\examples{
# Projected CRS
data(pts_pop_simul)
mat_dist <- mat_geo_dist(data=pts_pop_simul,
             ID = "ID",
             x = "x",
             y = "y")

#Polar CRS
city_us <- data.frame(name = c("New York City", "Chicago",
                               "Los Angeles", "Atlanta"),
                      lat  = c(40.75170,  41.87440,
                               34.05420,  33.75280),
                      lon  = c(-73.99420, -87.63940,
                              -118.24100, -84.39360))
mat_geo_us <- mat_geo_dist(data = city_us,
                           ID = "name", x = "lon", y = "lat",
                           crds_type = "polar")
}
\author{
P. Savary
}
