% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_fit.R
\name{gp_fit}
\alias{gp_fit}
\title{Fit a GP model}
\usage{
gp_fit(gp, x, y, trials = NULL, offset = NULL, jitter = NULL, ...)
}
\arguments{
\item{gp}{The gp model object to be fitted.}

\item{x}{n-by-d matrix of input values (n is the number of observations and d the input dimension).
Can also be a vector of length n if the model has only a single input.}

\item{y}{Vector of n output (target) values.}

\item{trials}{Vector of length n giving the number of trials for each observation in binomial
(and beta binomial) model.}

\item{offset}{Vector of constant values added to the latent values f_i (i = 1,...,n).
For Poisson models, this is the logarithm of the exposure time in each observation.}

\item{jitter}{Magnitude of diagonal jitter for covariance matrices for numerical stability.
Default is 1e-6.}

\item{...}{Currently ignored}
}
\value{
An updated GP model object.
}
\description{
Function \code{gp_fit} fits a GP model with the current hyperparameters.
Notice that this function does not optimize the hyperparameters in any way,
but only finds the analytical posterior approximation (depending on chosen
 \code{\link{approx}}) for the latent values with the current hyperparameters.
For optimizing the hyperparameter
values, see \code{gp_optim}.
}
\section{References}{


Rasmussen, C. E. and Williams, C. K. I. (2006). Gaussian processes for machine learning.
MIT Press.
}

\examples{

# Generate some toy data
set.seed(32004)
n <- 150
sigma <- 0.1
x <- rnorm(n)
ycont <- sin(3 * x) * exp(-abs(x)) + rnorm(n) * sigma
y <- rep(0, n)
y[ycont > 0] <- 1
trials <- rep(1, n)

# Fit the model using Laplace approximation (with the specified hyperparameters)
cf <- cf_sexp(lscale = 0.3, magn = 3)
gp <- gp_init(cf, lik_binomial())
gp <- gp_fit(gp, x, y, trials = trials)


}
