% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-grid.R
\name{gpkg_create_empty_grid}
\alias{gpkg_create_empty_grid}
\title{Create an empty grid table}
\usage{
gpkg_create_empty_grid(
  x,
  tile_matrix_set_name,
  datatype = "integer",
  scale = 1,
  offset = 0,
  precision = 1,
  data_null = NULL,
  grid_cell_encoding = "grid-value-is-center",
  uom = NULL,
  field_name = "Height",
  quantity_definition = "Height",
  srs_id = 4326,
  contents = TRUE,
  description = "",
  ext = c(-180, -90, 180, 90)
)
}
\arguments{
\item{x}{A \emph{geopackage} object}

\item{tile_matrix_set_name}{\emph{character}. New table name.}

\item{datatype}{\emph{character}. Either \code{"integer"} (default) or \code{"float"}.}

\item{scale}{\emph{numeric}. Default: \code{1.0}}

\item{offset}{\emph{numeric}. Default: \code{0.0}}

\item{precision}{\emph{numeric}. Default: \code{1.0}}

\item{data_null}{\emph{numeric}. Default: \code{NULL}}

\item{grid_cell_encoding}{\emph{character} Default: \code{"grid-value-is-center"}}

\item{uom}{\emph{character}. Unit of measure. Default: \code{NULL}}

\item{field_name}{\emph{character}. Default: \code{"Height"}.}

\item{quantity_definition}{\emph{character}. Default: \code{"Height"}}

\item{srs_id}{\emph{integer}. Spatial Reference System ID. Must be defined in \code{gpkg_spatial_ref_sys} table. Default: \code{4326}}

\item{contents}{\emph{logical}. Include entry in \code{gpkg_contents}? Default: \code{TRUE}}

\item{description}{\emph{character}. Description for \code{gpkg_contents}. Default: \code{""}}

\item{ext}{\emph{numeric}. Length 4. Extent (\code{c(xmin, ymin, xmax, ymax)}) for \code{gpkg_contents}. Default: \code{c(-180, -90, 180, 90)}}
}
\value{
\emph{integer}
}
\description{
Create an empty grid table and associated entries for \code{gpkg_spatial_ref_sys}, \code{gpkg_2d_gridded_coverage_ancillary}, and \code{gpkg_2d_gridded_tile_ancillary}.
}
