% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{gcnlp_post}
\alias{gcnlp_post}
\title{Send a POST request to the Google Cloud Natural Language API}
\usage{
gcnlp_post(text_body, extract_syntax = TRUE, extract_entities = TRUE,
  extract_document_sentiment = TRUE)
}
\arguments{
\item{text_body}{The text string to send to the API.}

\item{extract_syntax}{Behavior for the analyzeSyntax method. Defaults to \code{TRUE}. See \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeSyntax}{the API documentation} for more information.}

\item{extract_entities}{Behavior for the analyzeEntities method. Defaults to \code{TRUE}. See \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeEntities}{the API documentation} for more information.}

\item{extract_document_sentiment}{Behavior for the analyzeSentiment method. Defaults to \code{TRUE}. See \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeSentiment}{the API documentation} for more information.}
}
\value{
A list containing two elements: [1] \code{content} includes the parsed response, and contains the \code{sentences}, \code{tokens}, \code{entities}, \code{documentSentiment}, \code{language} results specified in the request. [2] \code{raw_response} contains the raw response from the API.
}
\description{
Send a POST request to the Google Cloud Natural Language API and retrieve the results.
}
\examples{
\dontrun{
gcnlp_post(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
           extract_syntax = TRUE,
           extract_entities = TRUE,
           extract_document_sentiment = TRUE)
}

}
