% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adwords.R
\name{ga_adwords_add_linkid}
\alias{ga_adwords_add_linkid}
\title{Creates a Google Analytics webProperty-Google Ads link}
\usage{
ga_adwords_add_linkid(adwordsAccountId, linkName, accountId, webPropertyId)
}
\arguments{
\item{adwordsAccountId}{the customer id of the Adwords account visible within the Adwords account UI on the top right corner -or accessible via the Adwords API}

\item{linkName}{a user defined way to call the link between the Adwords and Google Analytics accounts}

\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}
}
\value{
confirmation message if successful
}
\description{
Creates a link between and Adwords (Google ads) account and a Google Analytics property so that Adwords data can be accessed via Google Analytics and vice versa.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()

ga_adwords_add_linkid("280-234-7592", "Google Ads Link", "65973592", "UA-65973592-1")
}

}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webPropertyAdWordsLinks/insert}{Google documentation}

Other Google Ad management functions: 
\code{\link{ga_adwords}()},
\code{\link{ga_adwords_delete_linkid}()},
\code{\link{ga_adwords_list}()}
}
\concept{Google Ad management functions}
