% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.R
\name{gp}
\alias{gp}
\alias{goodpractice}
\title{Run good practice checks}
\usage{
gp(
  path = ".",
  checks = all_checks(),
  extra_preps = NULL,
  extra_checks = NULL,
  quiet = TRUE
)
}
\arguments{
\item{path}{Path to a package root.}

\item{checks}{Character vector, the checks to run. Defaults to
all checks. Use \code{\link{all_checks}} to list all checks.}

\item{extra_preps}{Custom preparation functions. See
\code{\link{make_prep}} on creating preparation functions.}

\item{extra_checks}{Custom checks. See \code{\link{make_check}} on
creating checks.}

\item{quiet}{Whether to suppress output from the preparation
functions. Note that not all preparation functions produce output,
even if this option is set to \code{FALSE}.}
}
\value{
A goodpractice object that you can query
with a simple API. See \code{\link{results}} to start.
}
\description{
To see the results, just print it to the screen.
}
\examples{
path <- system.file("bad1", package = "goodpractice")
# run a subset of all checks available
g <- gp(path, checks = all_checks()[3:16])
g
}
