% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM.R
\name{GLM}
\alias{GLM}
\title{Generalized linear model (abstract class)}
\description{
This class specializes \link{ParamRegrModel}. It is the abstract
base class for parametric generalized linear model objects with specific
distribution family such as \link{NormalGLM} and handles the (inverse) link
function.
}
\section{Super class}{
\code{\link[gofreg:ParamRegrModel]{gofreg::ParamRegrModel}} -> \code{GLM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GLM-new}{\code{GLM$new()}}
\item \href{#method-GLM-mean_yx}{\code{GLM$mean_yx()}}
\item \href{#method-GLM-clone}{\code{GLM$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="F1_yx"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-F1_yx'><code>gofreg::ParamRegrModel$F1_yx()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="F_yx"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-F_yx'><code>gofreg::ParamRegrModel$F_yx()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="f_yx"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-f_yx'><code>gofreg::ParamRegrModel$f_yx()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="fit"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-fit'><code>gofreg::ParamRegrModel$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="get_params"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-get_params'><code>gofreg::ParamRegrModel$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="sample_yx"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-sample_yx'><code>gofreg::ParamRegrModel$sample_yx()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="ParamRegrModel" data-id="set_params"><a href='../../gofreg/html/ParamRegrModel.html#method-ParamRegrModel-set_params'><code>gofreg::ParamRegrModel$set_params()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GLM-new"></a>}}
\if{latex}{\out{\hypertarget{method-GLM-new}{}}}
\subsection{Method \code{new()}}{
Initialize an object of class GLM.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GLM$new(linkinv = identity, params = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{linkinv}}{inverse link function, defaults to identity function}

\item{\code{params}}{model parameters to use as default (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new instance of the class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GLM-mean_yx"></a>}}
\if{latex}{\out{\hypertarget{method-GLM-mean_yx}{}}}
\subsection{Method \code{mean_yx()}}{
Evaluates the regression function or in other terms the
expected value of Y given X=x.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GLM$mean_yx(x, params = private$params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector of covariates}

\item{\code{params}}{model parameters to use, defaults to the fitted parameter
values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value of the regression function
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GLM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GLM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GLM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
