% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGtest.R
\name{test.ABEV1}
\alias{test.ABEV1}
\title{The first Allison-Betsch-Ebner-Visagie goodness-of-fit test for the inverse Gaussian family}
\usage{
test.ABEV1(data, a = 10, meth = "MME", B = 500)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{a}{positive tuning parameter.}

\item{meth}{method of estimation used. Possible values are \code{'MME'} for moment estimation and \code{'MLE'} for maximum likelihood estimation.}

\item{B}{number of bootstrap iterations used to obtain p value.}
}
\value{
a list containing the value of the name of the test statistic, the used tuning parameter, the parameter estimation method, the value of the test statistic, the bootstrap p value, the values of the estimators, and the number of bootstrap iterations: \cr
\describe{
        \item{\code{$Test}}{the name of the used test statistic.}
        \item{\code{$parameter}}{the value of the tuning parameter.}
        \item{\code{$est.method}}{the estimation method used.}
        \item{\code{$T.value}}{the value of the test statistic.}
        \item{\code{$p.value}}{the approximated p value.}
        \item{\code{$par.est}}{the estimated parameters.}
        \item{\code{$boot.run}}{number of bootstrap iterations.}
}
}
\description{
This function computes the goodness-of-fit test for the inverse Gaussian family due to Allison et al. (2019). Two different estimation procedures are implemented, namely the method of moment and the maximum likelihood method.
}
\details{
The test is of weighted \eqn{L^2} type and uses a characterization of the distribution function of the inverse Gaussian distribution. The p value is obtained by a parametric bootstrap procedure.
}
\examples{
test.ABEV1(rmutil::rinvgauss(20,2,1),B=100)

}
\references{
Allison, J.S., Betsch, S., Ebner, B., Visagie, I.J.H. (2019) "New weighted \eqn{L^2}-type tests for the inverse Gaussian distribution", arXiv:1910.14119. \href{https://arxiv.org/abs/1910.14119}{LINK}
}
