% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_taxa.R
\name{merge_taxa}
\alias{merge_taxa}
\title{Merge taxa with identical names}
\usage{
merge_taxa(
  vegtable,
  scale = "percentage",
  layers = "FALSE",
  method = "independent",
  clean_matrix = FALSE,
  backtransform = TRUE
)
}
\arguments{
\item{vegtable}{Data frame with samples in columns and taxa in rows. Taxon names must be in the first column.}

\item{scale}{Cover-abundance scale(s) of data. Default is percentage cover (values between 0 and 100) (\code{"percentage"}). Alternatively it can be one of the included scales in \code{\link{scale_tabs}} (e.g. \code{"braun.blanquet"}) or a custom scale defined as data frame following the same format.
You can also provide a vector of the same length as the number of samples, to define individual scales (from \code{\link{scale_tabs}}) for each sample.}

\item{layers}{A logical evaluation to \code{TRUE} or \code{FALSE} \emph{(default)} indicating whether vegetation layers are to be included with layer information stored in the second column.}

\item{method}{Choice of method to combine cover. \code{"independent"} \emph{(default)} or \code{"exclusive"}. See details for methods.}

\item{clean_matrix}{A logical evaluation to \code{TRUE} or \code{FALSE} \emph{(default)} indicating whether taxa that do not occur (i.e. sum of abundances is zero) or samples that are empty (i.e. do not have any taxa present) are to be removed.}

\item{backtransform}{A logical evaluation to \code{TRUE} \emph{(default)} or \code{FALSE} indicating whether cover-abundance values should be back-transformed into their original cover-abundance scale or left as percentage cover.}
}
\value{
A data frame based on \code{vegtable} with merged taxa.
}
\description{
The function offers a simple way to merge taxa with identical names in a vegetation table, e.g. due to necessary harmonization of the taxon level, to combine taxa of different layers or to remove duplicates.
The original cover-abundance scales are maintained.
}
\section{Details}{

The format required for this function is a data frame with samples in columns and taxa in rows, which corresponds to the export format of vegetation tables from Turboveg (Hennekens & Schaminee 2001).
Taxon names must be in the first column of the table (not row names as these do not allow duplicates).
If vegetation layers are to be included, layer information must be stored in the second column of the table. Taxa will then be merged only within the defined layers.

If a cover-abundance scale from \code{\link{scale_tabs}} is defined, all cover-abundance values will be transformed into percentage cover for the merging process, and then back-transformed into the original cover-abundance scale.

When combining cover values there are two possibilities following Fischer (2014) and Tichý & Holt (2011).
\itemize{
     \item \code{method = "independent" } \emph{(default)} assumes that covers can overlap and that they do so independently of each other (e.g. individuals of the lower layer are growing beneath individuals of the upper layer).
     In case of two layers the sum of the cover of layer 1 and layer 2 is the sum of the covers minus the overlap. ($p1 + p2- p1 * p2)
     Usually the choice when merging the same taxon from different (sub-)layers.
     \item \code{method = "exclusive" } assumes the covers are mutually exclusive, cover values will be simply summed up (e.g. individuals grow side by side).
     Usually the chouce when merging within layers, e.g. aggregating distinct taxa.
     }
Percentage cover values will eventually be truncated to 100%.

You may use the function \code{\link{trans_matrix}} to easily transpose the resulting vegetation table into a statistically analyzable species matrix.
}

\examples{
## Merge taxa with identical names without any layer information
# Transpose table to required format
schedenveg.t <- data.frame(species = names(schedenveg), t(schedenveg))
# Add two duplicated taxa
schedenveg.t <- rbind(schedenveg.t, schedenveg.t[c(55, 61), ])

# Merge duplicated taxa using default 'independent' method
schedenveg.merged <- merge_taxa(schedenveg.t, scale = "percentage")

}
\references{
Fischer, H. S. (2015): On the combination of species cover values from different vegetation layers.
\emph{Applied Vegetation Science}, \strong{18}: 169–170. \doi{https://doi.org/10.1111/avsc.12130}

Tichý, L. & Holt, J. (2011): JUICE. Program for management, analysis and classification of ecological data. Vegetation Science Group, Masaryk University Brno, CZ.
}
\author{
Friedemann von Lampe
}
