% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov2per.R
\name{cov2per}
\alias{cov2per}
\alias{per2cov}
\title{Conversion between cover-abundance codes and percentage cover}
\usage{
cov2per(matrix, scale = "braun.blanquet", multiscale = FALSE)

per2cov(matrix, scale = "braun.blanquet", multiscale = FALSE)
}
\arguments{
\item{matrix}{Community data, a vector or matrix-like object with cover-abundance values}

\item{scale}{Cover-abundance scale (from \code{\link{scale_tabs}}) or dataframe with custom conversion table following the same format.}

\item{multiscale}{A logical evaluation to \code{FALSE} \emph{(default)} or \code{TRUE} indicating whether individual scales per sample should be used. For individual scales, you must provide a vector of the same length as the number of samples to the \code{scale} argument, defining the scale (from \code{\link{scale_tabs}}) for each sample (with samples as rows in matrix).}
}
\value{
A dataframe or vector containing the transformed data
}
\description{
These functions perform a conversion between cover-abundance codes from different survey scales and percentage cover. They can be applied on a matrix-like object or a single vector.

\code{cov2per} performs conversion from cover-abundance to percentage values

\code{per2cov} performs conversion from percentage to cover-abundance values

You may chose between a set of scales with pre-defined conversion values, in \code{\link{scale_tabs}} or define your own conversion table following the same format.
}
\section{Details}{

If scales are not only cover-based but also abundance-based (e.g. Braun-Blanquet, Kohler) there are often no unique definitions about their conversion
into percentage cover. Therefore it is necessary to define and give reference to the applied conversion table.

Cover-abundance codes are transformed into the mean percentage cover of their class.
For the conversion of percentage cover to cover-abundance codes, all values between the lower and upper border of the class are transformed into the corresponding code.

The included cover-abundance scales and the associated conversion tables with references are explained in \code{\link{scale_tabs}}. On this site you also find definitions for defining a custom table.
}

\examples{
## Conversion of species matrix with percentage cover to Braun-Blanquet values
schedenveg.bb <- per2cov(schedenveg)

## Conversion of only 10 samples to Londo values
schedenveg.londo <- per2cov(schedenveg[, 1:10], scale = "londo")

## Conversion of species matrix with Braun-Blanquet values to percentage cover
schedenveg.per <- cov2per(schedenveg.bb)

}
\seealso{
\code{\link{scale_tabs}} for explanation and references of included conversion tables
}
\author{
Friedemann von Lampe
}
