% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.glsm.R
\encoding{UTF-8}
\name{confint.glsm}
\alias{confint.glsm}
\title{Confidence Intervals for Coefficients in \code{glsm} Objects}
\usage{
\method{confint}{glsm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{The type of prediction required. The default is on the scale of the linear predictors. The alternative \code{response} gives the predicted probabilities.}

\item{parm}{calculate confidence intervals for the coefficients}

\item{level}{It gives the desired confidence level for the confidence interval. For example, a default value is level = 0.95, which will generate a 95\% confidence interval."
The alternative \code{response} gives the predicted probabilities.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{"confint.glsm"}, which is a list containing:

\item{object}{a \code{glsm} object}
\item{parm}{calculate confidence intervals for the coefficients.}
\item{level}{confidence levels}
}
\description{
Calculates confidence intervals for the coefficients in a fitted \code{glsm} model. Includes exponentiated intervals (Odds Ratios) for easier interpretation.
}
\details{
Confint Method for 'glsm'

The saturated model is characterized by the assumptions 1 and 2 presented in section 2.3 by Llinas (2006, ISSN:2389-8976).
}
\examples{
# Load the glsm package and example dataset
library(glsm)
data("hsbdemo", package = "glsm")

# Fit a multinomial logistic regression model using glsm()
model <- glsm(prog ~ ses + gender, data = hsbdemo)

# Get confidence intervals for all model coefficients (default 95\% level)
confint(model)

# Get confidence intervals for a specific coefficient
params <- names(model$coefficients)

results <- lapply(params, function(p) {
  cat("\nConfidence interval for:", p, "\n")
  print(confint(model, parm = p, level = 0.95))
})

}
\references{
Hosmer, D., Lemeshow, S., & Sturdivant, R. (2013). \emph{Applied Logistic Regression} (3rd ed.). New York: Wiley. ISBN: 978-0-470-58247-3
Llinás, H. (2006). Precisiones en la teoría de los modelos logísticos. \emph{Revista Colombiana de Estadística}, 29(2), 239–265.
Llinás, H., & Carreño, C. (2012). The Multinomial Logistic Model for the Case in Which the Response Variable Can Assume One of Three Levels and Related Models. \emph{Revista Colombiana de Estadística}, 35(1), 131–138.
Orozco, E., Llinás, H., & Fonseca, J. (2020). Convergence theorems in multinomial saturated and logistic models. \emph{Revista Colombiana de Estadística}, 43(2), 211–231.
Llinás, H., Arteta, M., & Tilano, J. (2016). El modelo de regresión logística para el caso en que la variable de respuesta puede asumir uno de tres niveles: estimaciones, pruebas de hipótesis y selección de modelos. \emph{Revista de Matemática: Teoría y Aplicaciones}, 23(1), 173–197.
}
\author{
Humberto Llinás (Universidad del Norte, Barranquilla-Colombia; author),
Jorge Villalba (Universidad Tecnológica de Bolívar, Cartagena-Colombia; author and creator),
Jorge Borja (Universidad del Norte, Barranquilla-Colombia; author and creator),
Jorge Tilano (Universidad del Norte, Barranquilla-Colombia; author)
}
