% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glossary_add.R
\name{glossary_add}
\alias{glossary_add}
\title{Add a definition}
\usage{
glossary_add(term, def, path = glossary_path(), replace = FALSE)
}
\arguments{
\item{term}{The term to define}

\item{def}{The definition to add}

\item{path}{the path to the glossary file; set default with \code{\link{glossary_path}}}

\item{replace}{Whether to replace an existing definition}
}
\value{
NULL; Called for side effects
}
\description{
Write a term and definition to an existing glossary file.
}
\examples{
# make a new glossary file
path <- tempfile("glossary", fileext = ".yml")
glossary_path(path, create = TRUE)

# add an entry for "joins"
glossary_add("joins", "Ways to combine data from two tables")

# now you can access the definition
glossary("joins")
}
