% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{paramecium}
\alias{paramecium}
\title{Growth of Paramecium aurelium}
\format{
A data frame with 57 rows and 3 variables:
\describe{
  \item{Days}{a numeric vector indicating the time, in number of days.}
  \item{Colony}{a factor with three levels: "A", "B" and "C".}
  \item{Number}{a numeric vector indicating the number of individuals in the colony.}
}
}
\usage{
data(paramecium)
}
\description{
Data on the growth of three colonies of Paramecium
aurelium in a nutritive medium containing salt solution. In each
experiment, 20 Paramecia were placed in a tube with a constant
temperature medium. Starting on the second day, the number of
individuals is counted every day.
}
\examples{
data(paramecium)
dev.new()
with(paramecium,plot(Days,Number,ylab="Number of individuals",pch=20,
     xlab="Time, in days",
     col=ifelse(Colony=="A","black",ifelse(Colony=="B","blue","red"))))
legend(c(0,680),col=c("black","blue","red"),legend=c("A","B","C"),
       pch=20,title="Colony",bty="n")
}
\references{
Svetliza C.F., Paula G.A. (2003) Diagnostics in Nonlinear Negative Binomial Models. \emph{Communications in Statistics - Theory and Methods}, 32, 1227-1250.
}
\keyword{datasets}
