% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nested.glmnetr_250501.R
\name{plot.nested.glmnetr}
\alias{plot.nested.glmnetr}
\title{Plot results from a nested.glmnetr() output}
\usage{
\method{plot}{nested.glmnetr}(
  x,
  type = "devrat",
  alpha = NULL,
  gamma = NULL,
  lambda.lo = NULL,
  title = NULL,
  plup = 0,
  coefs = 0,
  comment = TRUE,
  pow = 2,
  ylim = 1,
  plot = 1,
  fold = 1,
  xgbsimple = 0,
  track = 0,
  ...
)
}
\arguments{
\item{x}{A nested.glmnetr output object}

\item{type}{type of plot to be produced from the (nested) cross validation 
model fits and evaluations. One of c("devrat", "devian", "agree", 
"intcal", "lincal") to plot estimates of one these performance measures. 
One of c("lasso", "elastic", "ridge") 
to plot model coefficients or deviances as function of lambda 
and to some degree gamma and alpha. Default is "devrat", 
the fractional reduction in deviance relative to the null model deviance. 
Use, "devrat" to plot deviance ratios, "devain" to plot devainces, 
"agree" to plot agreement e.g. R-square or concordance), "lincal" to plot 
the linear calibration slope coefficients, "intcal" to plot the 
linear calibration intercept coefficients or "devian" to plot the 
deviances from the nested cross validation. 
For each performance measure estimates from the individual (outer) 
cross validation fold are depicted by thin lines of different colors and styles, 
while the composite value from all folds is depicted by a thicker black line, 
and the performance measures naively calculated on the all data using the model 
derived from all data is depicted in a thicker red line.}

\item{alpha}{A specific value of alpha for plotting.  Used only when type is 
set to "elastic". Specifies which alpha is to be used for deviance plots.
Default is "alpha.min", else must be an element of the alpha vector used in 
running the elastic net model. This can be reviewed using summary(fit) 
where fit is a nested.glmnetr() output object. Note, alpha is 1 for the 
lasso model and alpha is 0 for the ridge model.}

\item{gamma}{A specific level of gamma for plotting.  By default gamma.min will 
be used.  Applies only for types in c("lasso", "elastic").}

\item{lambda.lo}{A lower limit of lambda when plotting.  Applies only for type = "lasso".}

\item{title}{A title}

\item{plup}{Plot upper 95 percent two-sided confidence intervals for the deviance 
plots.  Applies only for type = "lasso".}

\item{coefs}{1 (TRUE) to plot coefficients, else 0 (FALSE) to plot deviances 
as function of tuning paramters. Only applies for type in 
c("devrat", "devian", "agree", "intcal", "lincal").  See option 'type'.}

\item{comment}{Default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.  Applies only for type = "lasso".}

\item{pow}{Power to which agreement is to be raised when the "gaussian" model 
is fit, i.e. 2 for R-square, 1 for correlation.  Does not apply to type = "lasso".}

\item{ylim}{y axis limits for model performance plots, i.e. does not apply to 
type = "lasso".  The ridge model may calibrate very poorly obscuring plots for 
type of "lincal" or "intcal", so one may specify the ylim value.  If ylim is 
set to 1, then the program will derive a reasonable range for ylim.  If ylim is 
set to 0, then the entire range for all models will be displayed.  Does not 
apply to type = "lasso".}

\item{plot}{By default 1 to produce a plot, 0 to return the data used in the 
plot in the form of a list.}

\item{fold}{By default 1 to display model performance estimates form 
individual folds (or replicaitons for boostrap evaluations) when type of 
"agree", "intcal", "lincal", "devrat" for "devian". If 0 then the individual 
fold calculations are not displayed. When there are many replications as
sometimes the case when using bootstrap, one may specify the number of 
randomly selected lines for plotting.}

\item{xgbsimple}{1 (default) to include results for the untuned XGB model, 0 to not include.}

\item{track}{2 to track progress by printing to console, 0 (default) to 
not track.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
This program returns a plot to the graphics window, and may provide 
some numerical information to the R Console.
}
\description{
Plot the nested cross validation performance numbers, cross 
validated relaxed lasso deviances or coefficients from a nested.glmnetr() call.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
yg=sim.data$y_
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, yg, event, family="gaussian", folds_n=3, resample=0) 
plot(fit3)
plot(fit3, coefs=1)
}

}
\seealso{
\code{\link{plot_perf_glmnetr}} , \code{\link{calplot}} , \code{\link{plot.cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
\author{
Walter Kremers (kremers.walter@mayo.edu)
}
