
#' Simulate data with independent categorical covariates
#' @description This function generates a simulated data with independent categorical covariates. The first two covariates namely x1 and x2 are generated using random normal rnorm(n, 40, 20) and random poisson rpois(n, lambda = 4).The remaining covariates are generated at random with categories 0,1,2.
#' @param n numner of observations to be generated for the data
#' @param nCov 4+ number of covariates to be generated for the data, the first 4 covariates generated based on pre-specified distributions
#'
#' @return returns a data frame with covariates x1, x2, ...
#' @export
#'
#' @examples
#' simulateCovariateData(10, nCov=15)
#' @importFrom stats runif rbinom rpois rnorm
simulateCovariateData <- function(n, nCov = 2) {
  # Simulate data
  # Independent variables
  covariates <- list() # Create an empty list

  for (i in 5:(5+nCov)) {
    p <- stats::runif(1, min = 0.3, max = 0.5)
    covariates[[i]]<- rbinom(n, 2, p)
  }

  # Create a data frame with generated variables
  tt.orig <- data.frame(x1 = stats::rpois(n, lambda = 4), x2 = stats::rbinom(n, size=2, prob=0.4), x3 = stats::rbinom(n, size=1, prob=0.3), x4 = stats::rnorm(n, 40, 20), covariates[5:(5+nCov)])
  names(tt.orig) <- c("x1", "x2","x3","x4", paste0("x", 5:(5+nCov)))

  return(tt.orig)
}


