% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTheta.R
\name{getTheta}
\alias{getTheta}
\title{getTheta
Updates theta. Vectorized but only updates observations that have not converged.}
\usage{
getTheta(
  spt,
  f0,
  mu,
  sampprobs,
  ySptIndex,
  thetaStart = NULL,
  thetaControl = theta.control()
)
}
\arguments{
\item{spt}{Support of the observed response variable. (This is the set of
unique values observed, not the set of all possible values.)}

\item{f0}{Values of the baseline distribution corresponding to the values of spt}

\item{mu}{The fitted mean for each observation. Note these values must lie
strictly within the range of the support.}

\item{sampprobs}{Matrix of sampling probabilities. The number of rows should
equal the number of observations, and the number of columns should equal
the number of unique observed support points.}

\item{ySptIndex}{Vector containing index of each obervation's response value
within the \code{spt} vector. This is only needed to calculate the log-likelihood
after each update.}

\item{thetaStart}{Vector of starting values. One value per observation. If
\code{NULL}, zero is used as the starting value for each observation.}

\item{thetaControl}{Object of class \code{thetaControl}, which is a list of
control arguments returned by the \code{thetaControl} function.}
}
\value{
List containing the following:
\itemize{
\item \code{theta} Updated values.
\item \code{fTilt} Matrix containing the exponentially tilted distribution for each
observation, i.e. f(y|X=x). Each column corresponds to an observation and sums to one.
\item \code{bPrime} Vector containing the mean of the exponentially tilted distribution
for each observation. Should match \code{mu} argument very closely.
\item \code{bPrime2} Vector containing the variance of the exponentially tilted
distribution for each observation.
\item \code{fTiltSW} Matrix containing the exponentially tilted distribution for each
observation, conditional on that observation being sampled, i.e. f(y|X=x, S=1).
If \code{sampprobs=NULL}, then \code{fTiltSW} matches \code{fTilt}.
\item \code{bPrimeSW} Vector containing the mean for each observation, conditional
on that observation being sampled. If \code{sampprobs=NULL}, then \code{bPrimeSW}
matches \code{bPrime}.
\item \code{bPrime2SW} Vector containing the variance for each observation, conditional
on that observation being sampled. If \code{sampprobs=NULL}, then \code{bPrime2SW}
matches \code{bPrime2}.
\item \code{llik} Semiparametric log-likelihood, evaluated at the current beta
and f0 values. If sampling weights are used, then the log-likelihood is conditional
on each observation being sampled.
\item \code{conv} Convergence indicator.
\item \code{iter} Number of iterations until convergence was reached.
}
}
\description{
getTheta
Updates theta. Vectorized but only updates observations that have not converged.
}
\keyword{internal}
