% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{gghistweight2d_svy}
\alias{gghistweight2d_svy}
\title{Histogram of svy.object with One Facet}
\usage{
gghistweight2d_svy(surveyobj, x, y, binwidth = NULL)
}
\arguments{
\item{surveyobj}{svy.design object}

\item{x}{variable to histogram}

\item{y}{categorical variable to facet}

\item{binwidth}{binwidth to pass to geom_hist}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
}
\examples{
library(survey)
data(api)
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
gghistweight2d_svy(dstrat, api00, stype)
gghistweight2d_svy(dstrat, api00, stype, binwidth = 10)
}
