% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg3d-package.R, R/ggseg3d.R
\docType{package}
\name{ggseg3d}
\alias{ggseg3d}
\alias{ggseg3d-package}
\title{ggseg3d: Plot brain segmentations with plotly}
\usage{
ggseg3d(
  .data = NULL,
  atlas = "dk_3d",
  surface = "LCBC",
  hemisphere = c("right", "subcort"),
  label = "region",
  text = NULL,
  colour = "colour",
  palette = NULL,
  na.colour = "darkgrey",
  na.alpha = 1,
  show.legend = TRUE,
  options.legend = NULL,
  ...
)
}
\arguments{
\item{.data}{A data.frame to use for plot aesthetics. Must include a
column called "region" corresponding to regions.}

\item{atlas}{Either a string with the name of a 3d atlas to use.}

\item{surface}{String. Which surface to plot. Either "pial","white", or "inflated"[default]}

\item{hemisphere}{String. Hemisphere to plot. Either "left" or "right"[default],
can also be "subcort".}

\item{label}{String. Quoted name of column in atlas/data that should be used to name traces}

\item{text}{String. Quoted name of column in atlas/data that should be added as extra
information in the hover text.}

\item{colour}{String. Quoted name of column from which colour should be supplied}

\item{palette}{String. Vector of colour names or HEX colours. Can also be a named
numeric vector, with colours as names, and breakpoint for that colour as the value}

\item{na.colour}{String. Either name, hex of RGB for colour of NA in colour.}

\item{na.alpha}{Numeric. A number between 0 and 1 to control transparency of NA-regions.}

\item{show.legend}{Logical. Toggle legend if colour is numeric.}

\item{options.legend}{list of layout changes to colour bar}

\item{...}{additional arguments to \code{\link[plotly]{add_trace}}

\strong{Available surfaces:}
\itemize{
\item `inflated:` Fully inflated surface
\item `semi-inflated:` Semi-inflated surface
\item `white:` white matter surface
 }}
}
\value{
a plotly tri-surface mesh plot
}
\description{
Plotting results from analyses done on data derived from brain
segmentations is a common need, but may be quite laborious.
Results from such analyses are usually easier to interpret if
the plot can mimmick the shape and position in the brain it
represents.

\code{ggseg3d} plots and returns a plotly mesh3d object.
}
\details{
This package contains data from various brain parcellations,
with convenient functions to inspect the results directly on
a brain-plot wither with plotly in 3d meshes.
}
\examples{
ggseg3d()
ggseg3d(hemisphere = "left")
ggseg3d(surface = "inflated")
ggseg3d(show.legend = FALSE)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ggseg/ggseg3d/}
  \item Report bugs at \url{https://github.com/ggseg/ggseg3d/issues/}
}


\code{\link[plotly]{plot_ly}}, \code{\link[plotly]{add_trace}}, \code{\link[plotly]{layout}}, the plotly package
}
\author{
\strong{Maintainer}: Athanasia Mo Mowinckel \email{a.m.mowinckel@psykologi.uio.no} (\href{https://orcid.org/0000-0002-5756-0223}{ORCID})

Authors:
\itemize{
  \item Didac Vidal-Piñeiro \email{d.v.pineiro@psykologi.uio.no} (\href{https://orcid.org/0000-0001-9997-9156}{ORCID})
}


Athanasia Mowinckel and Didac Piñeiro
}
\keyword{internal}
